
const CustomLength = (Glide, Components, Events) => ({
	mount: () => Events.emit('slider.length', Components.Sizes.length)
});

const VisibleClass = function (Glide, Components, Events) {
	var Component = {
		mount () {
			this.setVisibleClasses();
		},

		setVisibleClasses () {
			if (Glide.settings.perView > 1) {
				const glideEl = Components.Html.root;
				const active = Components.Html.slides[Glide.index];

				// Calculate how many on each side we need to add visible classes to
				if (Glide.settings.focusAt === 'center') {
					var numBefore = Math.ceil((Glide.settings.perView - 1) / 2);
					var numAfter = numBefore;
				}
				else {
					var numBefore = Glide.settings.focusAt;
					var numAfter = Glide.settings.perView - Glide.settings.focusAt - 1;
				}

				// Remove visible classes
				glideEl.querySelectorAll('.glide__slide--visible').forEach(slide => {
					slide.classList.remove('glide__slide--visible');
				});

				// Add visible class to active slide
				active.classList.add('glide__slide--visible');

				// Add visible classes to next siblings
				var next = active;

				for (let i = 0; i < numAfter; i++) {
					if (!next) {
						return;
					}

					next = next.nextElementSibling;
					if (next) {
						next.classList.add('glide__slide--visible');
					}
				}

				// Add visible classes to previous siblings
				var prev = active;
				for (let i = 0; i < numBefore; i++) {

					if (!prev) {
						return;
					}

					prev = prev.previousElementSibling;

					if (prev) {
						prev.classList.add('glide__slide--visible');
					}
				}
			}
			else {
				Components.Html.root.querySelectorAll('.glide__slide--visible').forEach(slide => {
					slide.classList.remove('glide__slide--visible');
				});
				Components.Html.slides[Glide.index].classList.add('glide__slide--visible');
			}
		}
	};

	Events.on('run', () => {
		Component.setVisibleClasses();
	});

	return Component;
};