/**
 * logic to clickable tabs on website
 * @version 2.0.1
 * @package custom_tabs
 */

function changeUrlAnchor(anchor){
	anchor = '#' + anchor.replace('#', '');

	let actUrl = window.location.href;

	actUrl = actUrl.substring(0, actUrl.lastIndexOf("#"));

	actUrl += anchor;

	history.replaceState({}, 'Title', actUrl);
}

function changeTab(target, byHref, syncSlider = true){
	let targetId = '';
	if(byHref){
		targetId = target.getAttribute("href");
		changeUrlAnchor(targetId);
	}else {
		targetId = target.dataset.href;
	}

	if (!targetId)
		return;

	const tabBlock = document.querySelector(targetId);

	if (tabBlock === null)
		return;

	const tabNav = findAncestor(target, ".tabs");
	const tabContent = findAncestor(tabBlock, ".tabs-content");
	const activeLinks = tabNav.querySelectorAll(".tabs__link--active");
	const activeBlocks = tabContent.querySelectorAll(".tabs-content__block--active");

	/* Removes active class from other tabs */
	if (activeLinks) {
		for (let i = 0; i < activeLinks.length; i++) {
			activeLinks[i].classList.remove("tabs__link--active");
		}
	}

	/* Removes active class from other tab blocks */
	if (activeBlocks) {
		for (let i = 0; i < activeBlocks.length; i++) {
			activeBlocks[i].classList.remove("tabs-content__block--active");
		}
	}

	/* Adds active class to current tab and tab block */
	target.classList.add("tabs__link--active");
	tabBlock.classList.add("tabs-content__block--active");

	// Only sync slider if flag is true (avoid infinite loops)
	if (syncSlider && window.commonGlide && tabNav) {
		const links = tabNav.querySelectorAll('.tabs__link');
		const idx   = Array.prototype.indexOf.call(links, target);
		if (idx >= 0) {
			window.commonGlide.go('=' + idx);
		}
	}
}

document.addEventListener("click", function (e) {
	let target = e.target;

	let tab_root = findAncestor(target, '.js--tabs');

	let tab_link = findAncestor(target, ".tabs__link");

	if ((target.classList.contains("tabs__link") || tab_link) && tab_root) {

		if(tab_link){
			target = tab_link;
		}

		e.preventDefault();
		e.stopPropagation();
		e.stopImmediatePropagation();

		let byHref = true;

		if(typeof target.dataset.href !== 'undefined' && target.dataset.href !== ''){
			byHref = false;
		}

		changeTab(target, byHref);

		return false;
	}

});

document.addEventListener('DOMContentLoaded', function (){
	let url = window.location.href;
	let anchor = url.split('#')[1] || false;
	if(anchor){
		anchor = '#' + anchor;
		let tab = document.querySelector('[href="' + anchor + '"]');
		if(tab.classList.contains('tabs__link') && findAncestor(tab, '.js--tabs')){
			changeTab(tab, true);
		}
	}


	/**
	 * This functions expands the first item if a tabs-nav has data-init-expand attribute
	 */
	document.querySelectorAll('.js--tabs').forEach(function (tabsItem){
		let firstItem = tabsItem.querySelector('.tabs__link');
		if(typeof(tabsItem.dataset.initExpand) !== "undefined"){
			firstItem.classList.add('tabs__link--active');
			document.querySelector(firstItem.dataset.href).classList.add('tabs-content__block--active');
		}
	});
});